<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->mediumInteger('parent_id')->unsigned()->index()->default('null');
			$table->enum('type', array('corporation', 'Individuals', 'possible'))->index();
			$table->string('name_en', 190)->index();
			$table->string('name_ar', 190)->index();
			$table->enum('Identity_type', array('passport', 'driving_license', 'civil_number', 'business_identity', 'commercial_registration'));
			$table->string('Identity_number', 255)->index();
			$table->string('nationality', 190)->index();
			$table->text('address')->nullable();
			$table->char('country_code', 4)->default('+965');
			$table->string('phone_number', 20);
			$table->string('employee', 255)->nullable();
			$table->string('employee_phone_number', 20)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('nickname', 255)->nullable();
			$table->string('bank', 255)->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->string('iban_number', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}