<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCaseOpponentsTable extends Migration {

	public function up()
	{
		Schema::create('case_opponents', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('case_id')->unsigned();
			$table->string('name', 255);
			$table->string('id_number', 255)->default('0000000');
			$table->string('code', 255)->nullable();
			$table->text('home_address')->nullable();
			$table->text('work_address')->nullable();
			$table->string('country', 255)->nullable();
			$table->string('nationality', 255)->nullable();
			$table->string('home_phone', 255)->nullable();
			$table->smallInteger('age')->default('0');
			$table->string('job', 255)->nullable();
			$table->string('email_address')->nullable();
			$table->text('notes');
			$table->text('additional_notes')->nullable();
			$table->string('work_phone', 255)->nullable();
			$table->string('phone_number', 255)->nullable();
			$table->timestamps();
			$table->string('phone_number_2', 255)->nullable();
			$table->enum('gender', array('male', 'female'));
		});
	}

	public function down()
	{
		Schema::drop('case_opponents');
	}
}