<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Cart extends Model 
{

    protected $table = 'carts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('office_associate_id', 'sub_total', 'discount', 'total', 'note');

    public function items()
    {
        return $this->hasMany('CartItem');
    }

}