<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invoice extends Model 
{

    protected $table = 'invoices';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('office_associate_id', 'order_id', 'user_id', 'currency', 'receiver_email', 'ettn', 'status', 'pdf', 'send_status', 'print_status');

    public function order()
    {
        return $this->belongsTo('Order');
    }

}