<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'sub_total', 'cart_id', 'discount', 'total', 'note');

    public function items()
    {
        return $this->hasMany('OrderItem');
    }

    public function payment()
    {
        return $this->hasOne('OrderPayment');
    }

    public function invoice()
    {
        return $this->hasOne('Invoice');
    }

}