<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrderItem extends Eloquent {

	protected $table = 'order_items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('price', 'sub_total', 'grand_total', 'vat_rate');

	public function cart()
	{
		return $this->belongsTo('Order');
	}

	public function product()
	{
		return $this->belongsTo('Product');
	}

}