<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigIncrements('company_id');
			$table->integer('office_product_id');
			$table->string('name');
			$table->string('code');
			$table->enum('status', array('active', 'passive'));
			$table->string('product_type');
			$table->integer('critical_quantity');
			$table->float('purchase_price')->nullable();
			$table->float('sale_price')->nullable();
			$table->string('discount_type')->nullable();
			$table->float('discount_value')->nullable();
			$table->string('charge_type')->nullable();
			$table->float('charge_value')->nullable();
			$table->string('otv_type')->nullable();
			$table->float('otv_value')->nullable();
			$table->string('vat_type')->nullable();
			$table->float('vat_value')->nullable();
			$table->string('purchase_currency')->nullable();
			$table->string('sale_currency')->nullable();
			$table->boolean('purchase_price_vat_included')->nullable();
			$table->boolean('sale_price_vat_included')->nullable();
			$table->string('image')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}