<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('first_name', 'last_name', 'last_login_at');

	public function login_history()
	{
		return $this->hasMany('ChackoutLoginHistory');
	}

}