<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFormsFieldsTable extends Migration {

	public function up()
	{
		Schema::create('forms_fields', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('form_id')->unsigned();
			$table->string('field_identifier');
			$table->string('field_type');
			$table->string('field_title');
			$table->text('field_settings');
			$table->integer('field_order');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('forms_fields');
	}
}