<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateColloquesTable extends Migration {

	public function up()
	{
		Schema::create('colloques', function(Blueprint $table) {
			$table->increments('id');
			$table->string('titre', 255)->index();
			$table->string('url', 255);
			$table->string('lieu', 255);
			$table->integer('area_id')->unsigned();
			$table->integer('country_id')->unsigned();
			$table->text('commentaire');
			$table->date('date_start')->index();
			$table->date('date_end');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('colloques');
	}
}