<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RiscEvent extends Model 
{

    protected $table = 'events';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function place()
    {
        return $this->belongsTo('Place');
    }

    public function slots()
    {
        return $this->hasMany('Slot');
    }

    public function files()
    {
        return $this->hasMany('File');
    }

    public function envent_type()
    {
        return $this->belongsTo('Event_type');
    }

}