<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('event_type_id')->unsigned()->index();
			$table->string('title', 255)->index();
			$table->string('subtitle', 255);
			$table->text('details');
			$table->date('date_start');
			$table->date('date_end');
			$table->integer('place_id')->unsigned()->index();
			$table->text('contact');
			$table->string('url', 255);
			$table->text('comments');
			$table->string('image', 255);
			$table->boolean('valid');
			$table->integer('user_id')->unsigned()->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}