<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlacesTable extends Migration {

	public function up()
	{
		Schema::create('places', function(Blueprint $table) {
			$table->increments('id');
			$table->string('department', 255)->index();
			$table->string('institution', 255);
			$table->string('address1', 255);
			$table->string('address2', 255);
			$table->string('postal_code', 50);
			$table->string('city', 120);
			$table->integer('area_id')->unsigned()->index();
			$table->integer('country_id')->unsigned()->index();
			$table->string('subway', 120);
			$table->string('phone', 50);
			$table->text('comments');
			$table->integer('user_id')->unsigned()->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('places');
	}
}