<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('colloques', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('areas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('colloques', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('colloques', function(Blueprint $table) {
			$table->dropForeign('colloques_area_id_foreign');
		});
		Schema::table('colloques', function(Blueprint $table) {
			$table->dropForeign('colloques_country_id_foreign');
		});
	}
}