<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class RiscEvent extends Eloquent {

	protected $table = 'events';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function place()
	{
		return $this->belongsTo('Place');
	}

	public function slots()
	{
		return $this->hasMany('Slot');
	}

	public function files()
	{
		return $this->hasMany('File');
	}

	public function envent_type()
	{
		return $this->belongsTo('Event_type');
	}

}