<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 225);
			$table->longText('details');
			$table->integer('price');
			$table->integer('cat_id')->unsigned();
			$table->integer('menu_id')->unsigned();
			$table->integer('image')->unsigned();
			$table->timestamps();
			$table->integer('stock');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}