<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequirementsTable extends Migration {

	public function up()
	{
		Schema::create('requirements', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('ldap_attribute_id')->unsigned();
			$table->string('type');
			$table->integer('account_type_id')->unsigned()->index();
			$table->string('template')->nullable();
			$table->boolean('required');
			$table->string('validation_string', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('requirements');
	}
}