<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccountTypesTable extends Migration {

	public function up()
	{
		Schema::create('account_types', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('description', 255);
			$table->boolean('creation');
			$table->boolean('inbound_transition');
			$table->boolean('outbound_transition');
			$table->boolean('deletion');
		});
	}

	public function down()
	{
		Schema::drop('account_types');
	}
}