<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOperationalProfileRightsTable extends Migration {

	public function up()
	{
		Schema::create('operational_profile_rights', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('profile_id')->unsigned()->nullable();
			$table->integer('account_type_id')->unsigned();
			$table->boolean('create');
			$table->boolean('update');
			$table->boolean('delete');
			$table->string('ldap_filter');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('operational_profile_rights');
	}
}