<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGeneralSettingsTable extends Migration {

	public function up()
	{
		Schema::create('general_settings', function(Blueprint $table) {
			$table->increments('id');
			$table->string('contact_address', 255)->nullable();
			$table->string('telephone', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('copyright_content')->nullable();
			$table->string('webcastle_content', 255)->nullable();
			$table->text('site_logo')->nullable();
			$table->text('fav_icon')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('general_settings');
	}
}