<?php

namespace App;

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;

	public function getAuthor()
	{
		return $this->belongsTo('User', 'author_id');
	}

	public function getEvent()
	{
		return $this->hasOne('Event', 'event_id');
	}

	public function getComments()
	{
		return $this->hasMany('Comment');
	}

	public function getReactions()
	{
		return $this->hasMany('Reaction');
	}

	public function getAuthorizedUsers()
	{
		return $this->belongsToMany('User', 'post_visibility', 'user_id', 'post_id');
	}

	public function getSubPosts()
	{
		return $this->belongsToMany('Post', 'sub_post', 'child_post_id', 'parent_post_id');
	}

}