<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->bigInteger('event_id')->unique()->primary()->unsigned();
			$table->bigInteger('author_id')->unsigned()->index();
			$table->datetime('date');
			$table->string('name');
			$table->string('description')->nullable();
			$table->string('location');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}