<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('user_id')->primary()->unsigned();
			$table->string('name');
			$table->string('surname');
			$table->string('username')->unique();
			$table->string('email')->unique();
			$table->string('password');
			$table->enum('role', array('ADMIN', 'AUTHOR'));
			$table->datetime('birth_date');
			$table->string('title')->nullable();
			$table->string('cv_url')->nullable();
			$table->bigInteger('photo_id')->unsigned()->nullable();
			$table->bigInteger('cover_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}