<?php

namespace App;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	public function getPhoto()
	{
		return $this->hasOne('Post', 'photo_id');
	}

	public function getCover()
	{
		return $this->hasOne('Post', 'cover_id');
	}

	public function getConversations()
	{
		return $this->belongsToMany('Conversation', 'conversation_member', 'user_id', 'conversation_id');
	}

	public function getFriends()
	{
		return $this->belongsToMany('User', 'friend', 'friend2_id', 'friend1_id');
	}

	public function getFriendRequests()
	{
		return $this->hasMany('FriendRequest', 'invited_id');
	}

	public function getNotifications()
	{
		return $this->hasMany('Notification');
	}

}