<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Comment extends Model 
{

    protected $table = 'comments';
    public $timestamps = true;

    public function getPost()
    {
        return $this->belongsTo('Post', 'post_id');
    }

    public function getAuthor()
    {
        return $this->belongsTo('User', 'author_id');
    }

    public function getReactions()
    {
        return $this->hasMany('Reaction');
    }

}