<?php

namespace ReplyLive\Invitee;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Invitee extends Eloquent {

	protected $table = 'invitees';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function activities()
	{
		return $this->belongsToMany('Activity')->using(ActivityInvitee::class)->withPivot('status');
	}

	public function breakouts()
	{
		return $this->belongsToMany('Breakout')->using(BreakoutInvitee::class)->withPivot('status');
	}

}