<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessageNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('message_notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('message_id');
			$table->bigInteger('conversation_id');
			$table->bigInteger('participation_id');
			$table->boolean('is_seen')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('message_notifications');
	}
}