<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Reviews', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('Products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Reviews', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Order', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Order_item', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('Order')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Order_item', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('Products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('Reviews', function(Blueprint $table) {
			$table->dropForeign('Reviews_product_id_foreign');
		});
		Schema::table('Reviews', function(Blueprint $table) {
			$table->dropForeign('Reviews_user_id_foreign');
		});
		Schema::table('Order', function(Blueprint $table) {
			$table->dropForeign('Order_user_id_foreign');
		});
		Schema::table('Order_item', function(Blueprint $table) {
			$table->dropForeign('Order_item_order_id_foreign');
		});
		Schema::table('Order_item', function(Blueprint $table) {
			$table->dropForeign('Order_item_product_id_foreign');
		});
	}
}