<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRestaurantsTable extends Migration {

	public function up()
	{
		Schema::create('restaurants', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->string('name', 45);
			$table->text('address');
			$table->text('desc');
			$table->text('phone_no');
			$table->decimal('loc_lat', 15,8);
			$table->decimal('loc_long', 15,8);
			$table->text('profile_img');
			$table->text('cover_img')->nullable();
			$table->float('rating');
			$table->tinyInteger('price_range')->unsigned();
			$table->string('city', 255)->nullable();
			$table->string('country', 255)->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('restaurants');
	}
}