<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSessionsTable extends Migration {

	public function up()
	{
		Schema::create('sessions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->string('device_type', 255)->nullable();
			$table->string('device_id', 255)->nullable();
			$table->string('session_key', 255);
			$table->string('remember_token', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('sessions');
	}
}