<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTablesHistoryTable extends Migration {

	public function up()
	{
		Schema::create('tables_history', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('table_history_event_id')->unsigned();
			$table->integer('table_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->integer('waiter_user_id')->unsigned()->nullable();
			$table->integer('restaurant_id')->unsigned();
			$table->integer('table_state_id')->unsigned();
			$table->string('ref_code', 15);
			$table->string('merged_ids', 255)->nullable();
			$table->softDeletes();
			$table->timestamps();
			$table->timestamp('hist_updated_at');
			$table->timestamp('hist_created_at');
		});
	}

	public function down()
	{
		Schema::drop('tables_history');
	}
}