<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Menu extends Eloquent {

	protected $table = 'menus';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function restaurant()
	{
		return $this->hasOne('App\Models\Restaurant', 'restaurant_id');
	}

	public function menuItems()
	{
		return $this->belongsToMany('App\Models\MenuItem', 'menus_menu_items');
	}

}