<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MenuItem extends Eloquent {

	protected $table = 'menu_items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function menus()
	{
		return $this->belongsToMany('App\Models\Menu', 'menus_menu_items');
	}

	public function menuItemUserLikes()
	{
		return $this->belongsToMany('App\Models\User', 'menu_items_users_like', 'menu_item_id', 'user_id');
	}

}