<?php

namespace App\Models;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	public function user()
	{
		return $this->belongsTo('App\Models\User', 'user_id');
	}

	public function restaurant()
	{
		return $this->belongsTo('App\Models\Restaurant', 'restaurant_id');
	}

	public function orderState()
	{
		return $this->belongsTo('App\Models\OrderState', 'order_state_id');
	}

	public function orderType()
	{
		return $this->belongsTo('App\Models\OrderType', 'order_type_id');
	}

	public function orderPaymentType()
	{
		return $this->belongsTo('App\Models\OrderPaymentType', 'order_payment_type_id');
	}

	public function restaurantFeedbacks()
	{
		return $this->hasMany('App\Models\RestaurantFeedback', 'order_id');
	}

	public function menuItems()
	{
		return $this->belongsToMany('MenuItem', 'orders_menu_items', 'order_id', 'menu_item_id');
	}

	public function orderHistory()
	{
		return $this->hasMany('App\Models\OrderHistory', 'order_id');
	}

	public function table()
	{
		return $this->belongsTo('App\Models\Table', 'table_id');
	}

}