<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Restaurant extends Eloquent {

	protected $table = 'restaurants';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function users()
	{
		return $this->belongsToMany('App\Models\User', 'resturants_users');
	}

	public function menus()
	{
		return $this->hasMany('App\Models\Menu', 'resturant_id');
	}

	public function orders()
	{
		return $this->hasMany('App\Models\Order', 'resturant_id');
	}

	public function resturantUserLikes()
	{
		return $this->belongsToMany('App\Models\User', 'resturants_users_like', 'resturant_id', 'user_id');
	}

}