<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersHistoryTable extends Migration {

	public function up()
	{
		Schema::create('orders_history', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_history_event_id')->unsigned();
			$table->integer('order_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->integer('restaurant_id')->unsigned();
			$table->integer('order_state_id')->unsigned();
			$table->integer('coupon_id')->nullable();
			$table->integer('order_type_id')->unsigned();
			$table->integer('order_payment_type_id')->unsigned();
			$table->string('ref_code', 15)->nullable();
			$table->timestamp('hist_updated_at');
			$table->timestamp('hist_created_at');
			$table->timestamps();
			$table->integer('table_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('orders_history');
	}
}