<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sessions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('restaurants', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('restaurants_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('restaurants_users', function(Blueprint $table) {
			$table->foreign('resturant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('menu_items', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('menu_items', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('menu_items_feedbacks', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('menus', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('menus', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('menus_menu_items', function(Blueprint $table) {
			$table->foreign('menu_id')->references('id')->on('menus')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('menus_menu_items', function(Blueprint $table) {
			$table->foreign('menu_item_id')->references('id')->on('menu_items')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('table_id')->references('id')->on('tables')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('order_state_id')->references('id')->on('order_states')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('order_type_id')->references('id')->on('order_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('order_payment_type_id')->references('id')->on('order_payment_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tables', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tables', function(Blueprint $table) {
			$table->foreign('waiter_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tables', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tables', function(Blueprint $table) {
			$table->foreign('table_state_id')->references('id')->on('table_states')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cc_tokens', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders_menu_items', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders_menu_items', function(Blueprint $table) {
			$table->foreign('menu_item_id')->references('id')->on('menu_items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('menu_items_users_likes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('menu_items_users_likes', function(Blueprint $table) {
			$table->foreign('menu_item_id')->references('id')->on('menu_items')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('resturants_users_like', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('resturants_users_like', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('restaurant_feedbacks', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('restaurant_feedbacks', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('restaurant_feedbacks', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders_history', function(Blueprint $table) {
			$table->foreign('order_history_event_id')->references('id')->on('order_history_event')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders_history', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders_history', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders_history', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders_history', function(Blueprint $table) {
			$table->foreign('order_state_id')->references('id')->on('order_states')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders_history', function(Blueprint $table) {
			$table->foreign('order_type_id')->references('id')->on('order_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders_history', function(Blueprint $table) {
			$table->foreign('order_payment_type_id')->references('id')->on('order_payment_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders_history', function(Blueprint $table) {
			$table->foreign('table_id')->references('id')->on('tables')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tables_history', function(Blueprint $table) {
			$table->foreign('table_history_event_id')->references('id')->on('table_history_event')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tables_history', function(Blueprint $table) {
			$table->foreign('table_id')->references('id')->on('tables')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tables_history', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tables_history', function(Blueprint $table) {
			$table->foreign('waiter_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tables_history', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tables_history', function(Blueprint $table) {
			$table->foreign('table_state_id')->references('id')->on('table_states')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tables_diners', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tables_diners', function(Blueprint $table) {
			$table->foreign('table_id')->references('id')->on('tables')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('sessions', function(Blueprint $table) {
			$table->dropForeign('sessions_user_id_foreign');
		});
		Schema::table('restaurants', function(Blueprint $table) {
			$table->dropForeign('restaurants_user_id_foreign');
		});
		Schema::table('restaurants_users', function(Blueprint $table) {
			$table->dropForeign('restaurants_users_user_id_foreign');
		});
		Schema::table('restaurants_users', function(Blueprint $table) {
			$table->dropForeign('restaurants_users_resturant_id_foreign');
		});
		Schema::table('menu_items', function(Blueprint $table) {
			$table->dropForeign('menu_items_user_id_foreign');
		});
		Schema::table('menu_items', function(Blueprint $table) {
			$table->dropForeign('menu_items_restaurant_id_foreign');
		});
		Schema::table('menu_items_feedbacks', function(Blueprint $table) {
			$table->dropForeign('menu_items_feedbacks_user_id_foreign');
		});
		Schema::table('menus', function(Blueprint $table) {
			$table->dropForeign('menus_user_id_foreign');
		});
		Schema::table('menus', function(Blueprint $table) {
			$table->dropForeign('menus_restaurant_id_foreign');
		});
		Schema::table('menus_menu_items', function(Blueprint $table) {
			$table->dropForeign('menus_menu_items_menu_id_foreign');
		});
		Schema::table('menus_menu_items', function(Blueprint $table) {
			$table->dropForeign('menus_menu_items_menu_item_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_restaurant_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_table_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_order_state_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_order_type_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_order_payment_type_id_foreign');
		});
		Schema::table('tables', function(Blueprint $table) {
			$table->dropForeign('tables_user_id_foreign');
		});
		Schema::table('tables', function(Blueprint $table) {
			$table->dropForeign('tables_waiter_user_id_foreign');
		});
		Schema::table('tables', function(Blueprint $table) {
			$table->dropForeign('tables_restaurant_id_foreign');
		});
		Schema::table('tables', function(Blueprint $table) {
			$table->dropForeign('tables_table_state_id_foreign');
		});
		Schema::table('cc_tokens', function(Blueprint $table) {
			$table->dropForeign('cc_tokens_user_id_foreign');
		});
		Schema::table('orders_menu_items', function(Blueprint $table) {
			$table->dropForeign('orders_menu_items_order_id_foreign');
		});
		Schema::table('orders_menu_items', function(Blueprint $table) {
			$table->dropForeign('orders_menu_items_menu_item_id_foreign');
		});
		Schema::table('menu_items_users_likes', function(Blueprint $table) {
			$table->dropForeign('menu_items_users_likes_user_id_foreign');
		});
		Schema::table('menu_items_users_likes', function(Blueprint $table) {
			$table->dropForeign('menu_items_users_likes_menu_item_id_foreign');
		});
		Schema::table('resturants_users_like', function(Blueprint $table) {
			$table->dropForeign('resturants_users_like_user_id_foreign');
		});
		Schema::table('resturants_users_like', function(Blueprint $table) {
			$table->dropForeign('resturants_users_like_restaurant_id_foreign');
		});
		Schema::table('restaurant_feedbacks', function(Blueprint $table) {
			$table->dropForeign('restaurant_feedbacks_user_id_foreign');
		});
		Schema::table('restaurant_feedbacks', function(Blueprint $table) {
			$table->dropForeign('restaurant_feedbacks_order_id_foreign');
		});
		Schema::table('restaurant_feedbacks', function(Blueprint $table) {
			$table->dropForeign('restaurant_feedbacks_restaurant_id_foreign');
		});
		Schema::table('orders_history', function(Blueprint $table) {
			$table->dropForeign('orders_history_order_history_event_id_foreign');
		});
		Schema::table('orders_history', function(Blueprint $table) {
			$table->dropForeign('orders_history_order_id_foreign');
		});
		Schema::table('orders_history', function(Blueprint $table) {
			$table->dropForeign('orders_history_user_id_foreign');
		});
		Schema::table('orders_history', function(Blueprint $table) {
			$table->dropForeign('orders_history_restaurant_id_foreign');
		});
		Schema::table('orders_history', function(Blueprint $table) {
			$table->dropForeign('orders_history_order_state_id_foreign');
		});
		Schema::table('orders_history', function(Blueprint $table) {
			$table->dropForeign('orders_history_order_type_id_foreign');
		});
		Schema::table('orders_history', function(Blueprint $table) {
			$table->dropForeign('orders_history_order_payment_type_id_foreign');
		});
		Schema::table('orders_history', function(Blueprint $table) {
			$table->dropForeign('orders_history_table_id_foreign');
		});
		Schema::table('tables_history', function(Blueprint $table) {
			$table->dropForeign('tables_history_table_history_event_id_foreign');
		});
		Schema::table('tables_history', function(Blueprint $table) {
			$table->dropForeign('tables_history_table_id_foreign');
		});
		Schema::table('tables_history', function(Blueprint $table) {
			$table->dropForeign('tables_history_user_id_foreign');
		});
		Schema::table('tables_history', function(Blueprint $table) {
			$table->dropForeign('tables_history_waiter_user_id_foreign');
		});
		Schema::table('tables_history', function(Blueprint $table) {
			$table->dropForeign('tables_history_restaurant_id_foreign');
		});
		Schema::table('tables_history', function(Blueprint $table) {
			$table->dropForeign('tables_history_table_state_id_foreign');
		});
		Schema::table('tables_diners', function(Blueprint $table) {
			$table->dropForeign('tables_diners_user_id_foreign');
		});
		Schema::table('tables_diners', function(Blueprint $table) {
			$table->dropForeign('tables_diners_table_id_foreign');
		});
	}
}