<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('restaurant_id')->unsigned();
			$table->integer('table_id')->unsigned()->nullable();
			$table->integer('user_id')->unsigned();
			$table->integer('coupon_id')->nullable();
			$table->integer('order_state_id')->unsigned();
			$table->integer('order_type_id')->unsigned();
			$table->integer('order_payment_type_id')->unsigned();
			$table->string('ref_code', 15)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}