<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTablesTable extends Migration {

	public function up()
	{
		Schema::create('tables', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('waiter_user_id')->unsigned()->nullable();
			$table->integer('restaurant_id')->unsigned();
			$table->integer('table_state_id')->unsigned();
			$table->string('ref_code', 15)->nullable();
			$table->string('merged_ids', 255)->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tables');
	}
}