<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ads extends Model 
{

    protected $table = 'ads';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('expiration_date', 'status', 'factory_id', 'image', 'link', 'location');

    public function factory()
    {
        return $this->belongsTo('Factory', 'factory_id');
    }

}