<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FactoryContact extends Model 
{

    protected $table = 'factory_contact';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('factory_id', 'name', 'email', 'message');

    public function factory()
    {
        return $this->belongsTo('Factory', 'factory_id');
    }

}