<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFactoryTable extends Migration {

	public function up()
	{
		Schema::create('factory', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->string('sub_title_en')->nullable();
			$table->string('sub_title_ar')->nullable();
			$table->text('description_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->string('phone')->nullable();
			$table->string('website')->nullable();
			$table->string('email')->nullable();
			$table->string('facebook')->nullable();
			$table->string('twitter')->nullable();
			$table->string('instagram')->nullable();
			$table->string('linked_in')->nullable();
			$table->integer('country_id')->nullable();
			$table->integer('category_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('factory');
	}
}