<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FactoryContact extends Eloquent {

	protected $table = 'factory_contact';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('factory_id', 'name', 'email', 'message');

	public function factory()
	{
		return $this->belongsTo('Factory', 'factory_id');
	}

}