<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Ads extends Eloquent {

	protected $table = 'ads';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('expiration_date', 'status', 'factory_id', 'image', 'link', 'location');

	public function factory()
	{
		return $this->belongsTo('Factory', 'factory_id');
	}

}