<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFlightBookingsTable extends Migration {

	public function up()
	{
		Schema::create('flight_bookings', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->bigInteger('trip_id')->unsigned();
			$table->date('start_at');
			$table->date('end_at');
			$table->boolean('is_confirmed')->default(0);
			$table->bigInteger('flight_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('flight_bookings');
	}
}