<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVisaResultsTable extends Migration {

	public function up()
	{
		Schema::create('visa_results', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('document_id')->unsigned();
			$table->string('visa_number')->nullable();
			$table->string('name')->nullable();
			$table->date('birth_at')->nullable();
			$table->date('issue_at')->nullable();
			$table->date('expiry_at')->nullable();
			$table->string('entries')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('visa_results');
	}
}