<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVisasTable extends Migration {

	public function up()
	{
		Schema::create('visas', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('short_description');
			$table->bigInteger('country_id')->unsigned();
			$table->bigInteger('purpose_id')->unsigned();
			$table->text('detailed_description')->nullable();
			$table->integer('success_rate')->unsigned()->nullable();
			$table->integer('order')->unsigned()->nullable();
			$table->boolean('is_evisa')->default(0);
			$table->boolean('is_flight_mandatory')->default(0);
			$table->boolean('is_insurance_mandatory')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('visas');
	}
}