<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAirlinesTable extends Migration {

	public function up()
	{
		Schema::create('airlines', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->string('name');
			$table->string('iata')->unique()->nullable();
			$table->string('icao')->unique()->nullable();
			$table->string('alias');
			$table->string('callsign');
			$table->string('country');
			$table->string('status');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('airlines');
	}
}