<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('flight_bookings', function(Blueprint $table) {
			$table->foreign('trip_id')->references('id')->on('trips')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('flight_bookings', function(Blueprint $table) {
			$table->foreign('flight_id')->references('id')->on('flights')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('countries', function(Blueprint $table) {
			$table->foreign('continent_id')->references('id')->on('continents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_countries', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_countries', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->foreign('document_type_id')->references('id')->on('document_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_actions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_actions', function(Blueprint $table) {
			$table->foreign('action_id')->references('id')->on('actions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('region_countries', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('regions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('region_countries', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('passports', function(Blueprint $table) {
			$table->foreign('document_id')->references('id')->on('documents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('passports', function(Blueprint $table) {
			$table->foreign('nationality_country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('visa_results', function(Blueprint $table) {
			$table->foreign('document_id')->references('id')->on('documents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('visas', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('visas', function(Blueprint $table) {
			$table->foreign('purpose_id')->references('id')->on('purposes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->foreign('purpose_id')->references('id')->on('purposes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('flights', function(Blueprint $table) {
			$table->foreign('to_airport_id')->references('id')->on('airports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('flights', function(Blueprint $table) {
			$table->foreign('from_airport_id')->references('id')->on('airports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('flights', function(Blueprint $table) {
			$table->foreign('airline_id')->references('id')->on('airlines')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('airports', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('share_documents', function(Blueprint $table) {
			$table->foreign('document_id')->references('id')->on('documents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('share_documents', function(Blueprint $table) {
			$table->foreign('share_id')->references('id')->on('shares')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_offers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_offers', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_wants', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_wants', function(Blueprint $table) {
			$table->foreign('want_id')->references('id')->on('wants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trip_countries', function(Blueprint $table) {
			$table->foreign('trip_id')->references('id')->on('trips')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trip_countries', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('flight_schedules', function(Blueprint $table) {
			$table->foreign('flight_id')->references('id')->on('flights')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->foreign('trip_id')->references('id')->on('trips')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->foreign('lead_type_id')->references('id')->on('lead_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('share_logs', function(Blueprint $table) {
			$table->foreign('share_user_id')->references('id')->on('share_users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('share_users', function(Blueprint $table) {
			$table->foreign('share_id')->references('id')->on('shares')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('share_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_roles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_roles', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offer_options', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trip_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trip_users', function(Blueprint $table) {
			$table->foreign('trip_id')->references('id')->on('trips')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('document_pages', function(Blueprint $table) {
			$table->foreign('document_id')->references('id')->on('documents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_preferences', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_preferences', function(Blueprint $table) {
			$table->foreign('preference_id')->references('id')->on('preferences')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('flight_bookings', function(Blueprint $table) {
			$table->dropForeign('flight_bookings_trip_id_foreign');
		});
		Schema::table('flight_bookings', function(Blueprint $table) {
			$table->dropForeign('flight_bookings_flight_id_foreign');
		});
		Schema::table('countries', function(Blueprint $table) {
			$table->dropForeign('countries_continent_id_foreign');
		});
		Schema::table('user_countries', function(Blueprint $table) {
			$table->dropForeign('user_countries_user_id_foreign');
		});
		Schema::table('user_countries', function(Blueprint $table) {
			$table->dropForeign('user_countries_country_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_city_id_foreign');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->dropForeign('documents_user_id_foreign');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->dropForeign('documents_document_type_id_foreign');
		});
		Schema::table('user_actions', function(Blueprint $table) {
			$table->dropForeign('user_actions_user_id_foreign');
		});
		Schema::table('user_actions', function(Blueprint $table) {
			$table->dropForeign('user_actions_action_id_foreign');
		});
		Schema::table('region_countries', function(Blueprint $table) {
			$table->dropForeign('region_countries_region_id_foreign');
		});
		Schema::table('region_countries', function(Blueprint $table) {
			$table->dropForeign('region_countries_country_id_foreign');
		});
		Schema::table('passports', function(Blueprint $table) {
			$table->dropForeign('passports_document_id_foreign');
		});
		Schema::table('passports', function(Blueprint $table) {
			$table->dropForeign('passports_nationality_country_id_foreign');
		});
		Schema::table('visa_results', function(Blueprint $table) {
			$table->dropForeign('visa_results_document_id_foreign');
		});
		Schema::table('visas', function(Blueprint $table) {
			$table->dropForeign('visas_country_id_foreign');
		});
		Schema::table('visas', function(Blueprint $table) {
			$table->dropForeign('visas_purpose_id_foreign');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->dropForeign('trips_purpose_id_foreign');
		});
		Schema::table('flights', function(Blueprint $table) {
			$table->dropForeign('flights_to_airport_id_foreign');
		});
		Schema::table('flights', function(Blueprint $table) {
			$table->dropForeign('flights_from_airport_id_foreign');
		});
		Schema::table('flights', function(Blueprint $table) {
			$table->dropForeign('flights_airline_id_foreign');
		});
		Schema::table('airports', function(Blueprint $table) {
			$table->dropForeign('airports_country_id_foreign');
		});
		Schema::table('share_documents', function(Blueprint $table) {
			$table->dropForeign('share_documents_document_id_foreign');
		});
		Schema::table('share_documents', function(Blueprint $table) {
			$table->dropForeign('share_documents_share_id_foreign');
		});
		Schema::table('user_offers', function(Blueprint $table) {
			$table->dropForeign('user_offers_user_id_foreign');
		});
		Schema::table('user_offers', function(Blueprint $table) {
			$table->dropForeign('user_offers_offer_id_foreign');
		});
		Schema::table('user_wants', function(Blueprint $table) {
			$table->dropForeign('user_wants_user_id_foreign');
		});
		Schema::table('user_wants', function(Blueprint $table) {
			$table->dropForeign('user_wants_want_id_foreign');
		});
		Schema::table('trip_countries', function(Blueprint $table) {
			$table->dropForeign('trip_countries_trip_id_foreign');
		});
		Schema::table('trip_countries', function(Blueprint $table) {
			$table->dropForeign('trip_countries_country_id_foreign');
		});
		Schema::table('flight_schedules', function(Blueprint $table) {
			$table->dropForeign('flight_schedules_flight_id_foreign');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->dropForeign('leads_trip_id_foreign');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->dropForeign('leads_lead_type_id_foreign');
		});
		Schema::table('share_logs', function(Blueprint $table) {
			$table->dropForeign('share_logs_share_user_id_foreign');
		});
		Schema::table('share_users', function(Blueprint $table) {
			$table->dropForeign('share_users_share_id_foreign');
		});
		Schema::table('share_users', function(Blueprint $table) {
			$table->dropForeign('share_users_user_id_foreign');
		});
		Schema::table('user_roles', function(Blueprint $table) {
			$table->dropForeign('user_roles_user_id_foreign');
		});
		Schema::table('user_roles', function(Blueprint $table) {
			$table->dropForeign('user_roles_role_id_foreign');
		});
		Schema::table('offer_options', function(Blueprint $table) {
			$table->dropForeign('offer_options_offer_id_foreign');
		});
		Schema::table('trip_users', function(Blueprint $table) {
			$table->dropForeign('trip_users_user_id_foreign');
		});
		Schema::table('trip_users', function(Blueprint $table) {
			$table->dropForeign('trip_users_trip_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_country_id_foreign');
		});
		Schema::table('document_pages', function(Blueprint $table) {
			$table->dropForeign('document_pages_document_id_foreign');
		});
		Schema::table('user_preferences', function(Blueprint $table) {
			$table->dropForeign('user_preferences_user_id_foreign');
		});
		Schema::table('user_preferences', function(Blueprint $table) {
			$table->dropForeign('user_preferences_preference_id_foreign');
		});
	}
}