<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name')->nullable();
			$table->string('logo', 255)->nullable();
			$table->text('description')->nullable();
			$table->integer('facebook_link')->nullable();
			$table->string('whatsapp_link')->nullable();
			$table->string('twitter_link')->nullable();
			$table->tinyInteger('youtube_link')->nullable();
			$table->string('tiktok_link')->nullable();
			$table->string('hero_file', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}